/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.Collection;
import java.util.Collections;
import jnr.netdb.FileServicesDB;
import jnr.netdb.IANAServicesDB;
import jnr.netdb.NativeServicesDB;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Service {
    private final String serviceName;
    private final int port;
    final String proto;
    private final Collection<String> aliases;

    Service(String string, int n, String string2, Collection<String> collection) {
        this.serviceName = string;
        this.port = n;
        this.proto = string2;
        this.aliases = collection;
    }

    public static final Service getServiceByName(String string, String string2) {
        return Service.getServicesDB().getServiceByName(string, string2);
    }

    public static final Service getServiceByPort(int n, String string) {
        return Service.getServicesDB().getServiceByPort(n, string);
    }

    public static final Collection<Service> getAllServices() {
        return Collections.emptyList();
    }

    public final String getName() {
        return this.serviceName;
    }

    public final int getPort() {
        return this.port;
    }

    public final Collection<String> getAliases() {
        return this.aliases;
    }

    private static final ServicesDB getServicesDB() {
        return ServicesDBSingletonHolder.INSTANCE;
    }

    public String toString() {
        return String.format("<Service: Name: %s, Port: %d, Proto: %s, Aliases: %s>", this.serviceName, this.port, this.proto, this.aliases);
    }

    private static final class ServicesDBSingletonHolder {
        static final ServicesDB INSTANCE = ServicesDBSingletonHolder.load();

        private ServicesDBSingletonHolder() {
        }

        private static final ServicesDB load() {
            ServicesDB servicesDB = NativeServicesDB.load();
            if (servicesDB == null) {
                servicesDB = FileServicesDB.getInstance();
            }
            return servicesDB != null ? servicesDB : IANAServicesDB.getInstance();
        }
    }
}

